%setting up environment
clear; clc; close all
addpath(genpath(('C:\Users\Paolo Tasseron\OneDrive - Wageningen University & Research')));

%loading data and storing it to variables
data = readtable(['C:\Users\Paolo Tasseron\OneDrive - Wageningen University & Research\Paper projects' ...
    '\Riverbank detailed experiments paper\Experimenten\Experiment_data_Alphen.xlsx']);

load("cum_plt_perc_alphen.mat"); load("cum_plt_perc_arnhem.mat"); load("cum_plt_perc_doesburg.mat"); load('cum_plt_perc_nijmegen.mat'); load('cum_plt_perc_rhenen.mat'); load("cum_plt_perc_tiel.mat"); load("cum_plt_perc_vuren.mat"); load("cum_plt_perc_wanssum.mat");
load("data_river_oriented_normalized_alphen.mat"); load("data_river_oriented_normalized_arnhem.mat"); load("data_river_oriented_normalized_doesburg.mat"); load("data_river_oriented_normalized_nijmegen.mat"); load("data_river_oriented_normalized_tiel.mat"); load("data_river_oriented_normalized_vuren.mat"); load("data_river_oriented_normalized_rhenen.mat"); load("data_river_oriented_normalized_wanssum.mat")
load("data_river_oriented_alphen.mat"); load("data_river_oriented_arnhem.mat"); load("data_river_oriented_doesburg.mat"); load("data_river_oriented_nijmegen.mat"); load("data_river_oriented_tiel.mat"); load("data_river_oriented_vuren.mat"); load("data_river_oriented_rhenen.mat"); load("data_river_oriented_wanssum.mat")
data_river_oriented_wanssum = data_river_oriented; clear data_river_oriented;

%% Generating plots of litter distribution (one time only, the plots have already been saved and loaded in lines 6-11)
% %generating labels in image
% t = num2cell(round(data_river_oriented./total_items*100,1));
% t = cellfun(@num2str, t,'UniformOutput',false);
% x = repmat(1:20,5,1); y = repmat(1:5,20,1)';
% 
% for i = 1:size(data_river_oriented,1)
%     for j = 1:size(data_river_oriented,2)
%         if data_river_oriented(i,j) > 0.5 * max(data_river_oriented(:))
%            text(x(i,j),y(i,j),t(i,j),'HorizontalAlignment','right','VerticalAlignment','bottom','color','k');
%         else 
%            text(x(i,j),y(i,j),t(i,j),'HorizontalAlignment','right','VerticalAlignment','bottom','color','w');
%         end
%     end
% end
% items_within_5m = sum(data_river_oriented(5,:))./sum(data_river_oriented(:))*100;
% items_within_10m = sum(sum(data_river_oriented(4:5,:)))./sum(data_river_oriented(:))*100;
% fprintf('%d percent within 5m \n %d percent within 10m. \n',round(items_within_5m),round(items_within_10m)

%% Creating figure of the normalized data - riverbank distribution (a) and plot of %litter on %locations (b)
close all;
figure('DefaultAxesFontSize',13); set(gcf,'Position',[100 100 1700 800]); 

subplot(2,6,1); 
imagesc(rot90(data_river_oriented_normalized_alphen),'XData',1/2,'Ydata',1/2); axis image; grid on; colormap(othercolor('Blues9')); a.Label.String = "";
set(gca,'GridColor','k'); title(['Alphen (0.106)']);
set(gca,'Ytick',[0:1:20]); set(gca,'Xtick',[0:1:5]); 
yticklabels({'100','','90','','80','','70','','60','','50','','40','','30','','20','','10','','0'}); xticklabels({'25','20','15','10','5','0'});
%ylabel('Riverbank width (m)'); xlabel('length (m)');

subplot(2,6,2); 
imagesc(rot90(data_river_oriented_normalized_arnhem),'XData',1/2,'Ydata',1/2); axis image; grid on; colormap(othercolor('Blues9')); a.Label.String = "";
set(gca,'Ytick',[0:1:5]); set(gca,'GridColor','k'); title(['Arnhem (0.023)']);
set(gca,'Ytick',[0:1:20]); set(gca,'Xtick',[0:1:5]); 
yticklabels({'100','','90','','80','','70','','60','','50','','40','','30','','20','','10','','0'}); xticklabels({'25','20','15','10','5','0'});


subplot(2,6,3); 
imagesc(rot90(data_river_oriented_normalized_doesburg),'XData',1/2,'Ydata',1/2); axis image; grid on; colormap(othercolor('Blues9')); a.Label.String = "";
set(gca,'GridColor','k'); title(['Doesburg (0.268)']);
set(gca,'Ytick',[0:1:20]); set(gca,'Xtick',[0:1:5]); 
yticklabels({'100','','90','','80','','70','','60','','50','','40','','30','','20','','10','','0'}); xticklabels({'25','20','15','10','5','0'});


subplot(2,6,4); 
imagesc(rot90(data_river_oriented_normalized_nijmegen),'XData',1/2,'Ydata',1/2); axis image; grid on; colormap(othercolor('Blues9')); a.Label.String = "";
set(gca,'GridColor','k'); title(['Nijmegen (0.073)']);
set(gca,'Ytick',[0:1:20]); set(gca,'Xtick',[0:1:5]); 
yticklabels({'100','','90','','80','','70','','60','','50','','40','','30','','20','','10','','0'}); xticklabels({'25','20','15','10','5','0'});


subplot(2,6,7); 
imagesc(rot90(data_river_oriented_normalized_rhenen),'XData',1/2,'Ydata',1/2); axis image; grid on; colormap(othercolor('Blues9')); a.Label.String = "";
set(gca,'GridColor','k'); title(['Rhenen (0.289)']);
set(gca,'Ytick',[0:1:20]); set(gca,'Xtick',[0:1:5]); 
yticklabels({'100','','90','','80','','70','','60','','50','','40','','30','','20','','10','','0'}); xticklabels({'25','20','15','10','5','0'});


subplot(2,6,8); 
imagesc(rot90(data_river_oriented_normalized_tiel),'XData',1/2,'Ydata',1/2); axis image; grid on; colormap(othercolor('Blues9')); a.Label.String = "";
set(gca,'GridColor','k'); title(['Tiel (-0.050)']);
set(gca,'Ytick',[0:1:20]); set(gca,'Xtick',[0:1:5]); 
yticklabels({'100','','90','','80','','70','','60','','50','','40','','30','','20','','10','','0'}); xticklabels({'25','20','15','10','5','0'});

subplot(2,6,9); 
imagesc(rot90(data_river_oriented_normalized_vuren),'XData',1/2,'Ydata',1/2); axis image; grid on; colormap(othercolor('Blues9')); a.Label.String = "";
set(gca,'GridColor','k'); title(['Vuren (0.234)']);
set(gca,'Ytick',[0:1:20]); set(gca,'Xtick',[0:1:5]); 
yticklabels({'100','','90','','80','','70','','60','','50','','40','','30','','20','','10','','0'}); xticklabels({'25','20','15','10','5','0'});

subplot(2,6,10); 
imagesc(rot90(data_river_oriented_normalized_wanssum),'XData',1/2,'Ydata',1/2); axis image; grid on; colormap(othercolor('Blues9')); a.Label.String = "";
set(gca,'GridColor','k'); title(['Wanssum (0.301)']);
set(gca,'Ytick',[0:1:20]); set(gca,'Xtick',[0:1:5]); 
yticklabels({'100','','90','','80','','70','','60','','50','','40','','30','','20','','10','','0'}); xticklabels({'25','20','15','10','5','0'});

subplot(1,3,3);
plot(cum_plt_perc_alphen.*100,Color=[68/255,119/255,170/255],LineWidth = 1.75); hold on;
plot(cum_plt_perc_arnhem.*100,Color=[102/255,204/255,238/255],LineWidth = 1.75);
plot(cum_plt_perc_doesburg.*100,Color=[204/255,187/255,68/255],LineWidth = 1.75);
plot(cum_plt_perc_nijmegen.*100,Color=[238/255,102/255,119/255],LineWidth = 1.75);
plot(cum_plt_perc_rhenen.*100,Color=[34/255,136/255,51/255],LineWidth = 1.75);
plot(cum_plt_perc_tiel.*100,Color=[170/255,51/255,119/255],LineWidth = 1.75);
plot(cum_plt_perc_vuren.*100,Color=[187/255,187/255,187/255],LineWidth = 1.75);
plot(cum_plt_perc_wanssum.*100,Color=[68/255,68/255,68/255],LineWidth = 1.75);

ylabel('Share of pollution (% items of total)'); xlabel('Surface area (% of total)');  grid on;
legend('Alphen','Arnhem','Doesburg','Nijmegen','Rhenen','Tiel','Vuren','Wanssum','Location','Southeast')

%% Monte Carlo analyses and random sampling
% Monte carlo runs have already been made for each monitored location.

data = readtable(['C:\Users\Paolo Tasseron\OneDrive - ' ...
    'Wageningen University & Research\Paper projects' ...
    '\Riverbank detailed experiments paper\Experimenten' ...
    '\Experiment_data_Wanssum.xlsx']); %Load a specific data table for this part of the calculations

close all
data_array = table2array(data(2:end,3:102));
data_totals = sum(data_array,"omitnan");
data_shaped = reshape(data_totals,20,5);
data_river_oriented = rot90(data_shaped(:,:));
total_items = sum(data_totals);

%Clean Rivers
sr_total = sum(sum(data_array)); %Calculate true total
sr_density = sr_total ./(100*25); %Calculate true density

%Plastic pirates montecarlo
sample_area_plastic_pirates = pi*1.5^2/25; %divide by 25 to get #items per square. This is purely a factor, assuming items within 5 by 5m square are homogeneously distributed
pp= [];

for j = 1:10000
    rand1 = randperm(20,2); rand2 = randperm(20,2); rand3 = randperm(20,2);
    pp(j) = sample_area_plastic_pirates * (  data_river_oriented(1,rand1(1)) + data_river_oriented(3,rand2(1)) + data_river_oriented(5,rand3(1)) + ...
                                data_river_oriented(1,rand1(2)) + data_river_oriented(3,rand2(2)) + data_river_oriented(5,rand3(2)));
end

pp_dens = pp./(pi*1.5^2*6); %calculating density 

%NOAA montecarlo
noaa = [];
sample_area_NOAA = 5*25*4;


for j = 1:10000
    rand1 = randperm(20,4); 
    noaa(j) = (sum(data_river_oriented(:,rand1(1)),"omitnan") + sum(data_river_oriented(:,rand1(2))) + sum(data_river_oriented(:,rand1(3))) ...
                                   + sum(data_river_oriented(:,rand1(4))));
end

noaa_dens = noaa./sample_area_NOAA;

% CrowdWater montecarlo for a stretch that is 1, 2, 5 or 10m long
cw = [];

for j = 1:10000
    rand1 = randi(20);
    x = rand();
    A=ones(2,1); A(1,:)=ceil(19*rand(1,size(A,2))); A=cumsum(A(:)); %this line generates a set of 2 consecutive numbers between 1, and 20.
    if x>0.25
        cw(j) = sum(data_river_oriented(:,rand1),"omitnan")./(25*5); %3x chance of 1,2,5m, 1x chance of 10m. doesnt matter to downscale 1,2,5m -> per area will be same
    else
        cw(j) = sum(sum(data_river_oriented(:,A),"omitnan"))./(25*5*2);
    end
end

%Battulga montecarlo
bat = [];                                                                   %empty array

for j = 1:10000
    Q = [1:100]; Qna = [5:5:95 96:100];                                     %reset Q array, with boundaries taken in account
    Q = Q(~ismember(Q,Qna));
    selected_Q = Q(randi(length(Q),1));                                     %select a 5x5m square
    selected_Qsq1 = [selected_Q selected_Q+1 selected_Q+5 selected_Q+6];    %select indices of belonging 10x10m square
    Q = Q(~ismember(Q,selected_Qsq1));                                      %exclude first square

    selected_Q = Q(randi(length(Q),1));                                     %select 2nd 5x5m square
    selected_Qsq2 = [selected_Q selected_Q+1 selected_Q+5 selected_Q+6];    %select indices of belonging 10x10m square
    Q = Q(~ismember(Q,selected_Qsq2));                                      %exclude 2nd square

    selected_Q = Q(randi(length(Q),1));                                     %select 2nd 5x5m square
    selected_Qsq3 = [selected_Q selected_Q+1 selected_Q+5 selected_Q+6];    %select indices of beloging 10x10m square

    bat(j) = sum(data_river_oriented(selected_Qsq1)) + sum(data_river_oriented(selected_Qsq2)) + sum(data_river_oriented(selected_Qsq3));
end

bat_dens = bat./300;                                                       %Calculate item density per meter

%%random monte carlo
random_arr= [];
for i = 1:100
    random_arr_matrix = [];
    sample_area_random = 5*5*i;
    for j = 1:10000
        rand1 = randperm(100,i); 
        random_arr_matrix(j) = sum(data_river_oriented(rand1));
    end
    random_arr(i,:) = random_arr_matrix;
    random_dens(i,:) = random_arr_matrix./sample_area_random;
end

random_table = array2table(random_dens');
random_array = table2array(random_table);
standard_error = std(random_dens')./sqrt(size(random_dens,2));

rand_uncertainty = zeros([1 100]);

for i = 1:100
    rand_uncertainty(i) = std(random_dens(i,:))./mean(random_dens(i,:));
end

%% Plotting random sampling versus protocol normalized standard deviation
load("C:\Users\Paolo Tasseron\OneDrive - Wageningen University & Research\Paper projects\Riverbank detailed experiments paper\uncertainty.csv")
load("C:\Users\Paolo Tasseron\OneDrive - Wageningen University & Research\Paper projects\Riverbank detailed experiments paper\uncertainty_random_normalized_std.csv")

battulga_uncertainty = [1.04 0.56 0.49 0.12 0.8 0.29 0.5 0.94];
crowdwater_uncertainty = [0.8 0.68 0.49 0.14 0.95 0.4 0.65 0.49];
noaa_uncertainty = [0.39 0.33 0.23 0.07 0.44 0.2 0.31 0.23];
plastic_pirates_uncertainty = [0.71 0.54 0.46 0.13 0.68 0.31 0.64 0.32];
legend('Alphen','Arnhem','Doesburg','Nijmegen','Rhenen','Tiel','Vuren','Wanssum','Average')

Q = mean(uncertainty(:,9:16)');
x = [25:25:2500];

% Define the coefficients for the first function
a = 6.249;
b = -0.3857;
c = -0.2513;

% Define the coefficients for the second function
p1 = -9.293e-11;
p2 = 4.637e-07;
p3 = -0.0008434;
p4 = 0.6623;

% Define the piecewise function
piecewise_function = @(x) (x <= 1225) .* (a * x.^b + c) + (x > 1225) .* (p1 * x.^3 + p2 * x.^2 + p3 * x + p4);

% Generate x values
x_values = linspace(25, 2500, 100); % Adjust the number of points as needed

% Evaluate the piecewise function at x values
y_values = piecewise_function(x_values); y_values(1) = 2.6155;
y_values_normalized = (y_values - min(y_values)) ./ max(y_values) - min(y_values);

battulga_normalized = (battulga_uncertainty - min(y_values)) ./ max(y_values) - min(y_values);
crowdwater_normalized = (crowdwater_uncertainty - min(y_values)) ./ max(y_values) - min(y_values);
noaa_normalized = (noaa_uncertainty - min(y_values)) ./ max(y_values) - min(y_values);
plastic_pirates_normalized = (plastic_pirates_uncertainty - min(y_values)) ./ max(y_values) - min(y_values);
accuracy_increase = abs(diff(y_values_normalized))*100;

% Plot the combined function
close all
fig = figure('defaultAxesFontSize',13); 
rnd_nrm = zeros([100,8]);

for i = 1:8
    rnd_nrm(:,i) = (uncertainty_random_normalized_std(:,i) - min(y_values)) ./ max(y_values) - min(y_values);
end

rnd_rng = max(rnd_nrm') - min(rnd_nrm');
upper_bnd = y_values+rnd_rng;
lower_bnd = y_values-rnd_rng;
hold on;
fill([x_values,fliplr(x_values)],[upper_bnd,fliplr(lower_bnd)], [0.8 0.8 0.8], 'FaceAlpha', 0.5, 'EdgeColor', 'none');

plot(x_values,y_values,'LineWidth',1.5,'Color',[.5 .5 .5]); grid on;
ylim([0 1.5]); xticks([0:250:2500]); xticklabels([0:250:2500]); ylabel('Normalized standard deviation (σ/μ)'); xlabel('Sampled surface area (m^2)')
yticks([0 0.25 0.5 0.75 1 1.25 1.5]);
line([300,300],[min(battulga_uncertainty) max(battulga_uncertainty)],'LineWidth',1.5,'Color',[221/255,170/255,51/255]); hold on;  scatter(300,mean(battulga_uncertainty),50,'filled','Markerfacecolor',[201/225,150/225,31/225]','HandleVisibility','off');
line([112,112],[min(crowdwater_uncertainty) max(crowdwater_uncertainty)],'LineWidth',1.5,'Color',[187/255 85/255 102/255]); hold on; scatter(112,mean(crowdwater_uncertainty),50,'filled','Markerfacecolor',[167/255 65/255 82/255],'HandleVisibility','off');
line([500,500],[min(noaa_uncertainty) max(noaa_uncertainty)],'LineWidth',1.5,'Color',[15/255 68/255 136/255]); hold on;  scatter(500,mean(noaa_uncertainty),50,'filled','Markerfacecolor',[0/255 48/255 116/255],'HandleVisibility','off');
line([42,42],[min(plastic_pirates_uncertainty) max(plastic_pirates_uncertainty)],'LineWidth',1.5,'Color',[10/255 10/255 10/255]); hold on;  scatter(42,mean(plastic_pirates_uncertainty),50,'filled','ok');
legend('Random sampling','Random sampling (mean)','Battulga','Crowdwater','Noaa','Plastic Pirates','Mean','Location','EastOutside')
scatter([300 300 300 300 300 300 300 300],battulga_uncertainty,15,'filled','Markerfacecolor',[201/255,150/255,31/255],'HandleVisibility','off'); hold on
scatter([112 112 112 112 112 112 112 112],crowdwater_uncertainty,15,'filled','Markerfacecolor',[167/255 65/255 82/255],'HandleVisibility','off'); hold on
scatter([500 500 500 500 500 500 500 500],noaa_uncertainty,15,'filled','Markerfacecolor',[0/255 48/255 116/255],'HandleVisibility','off'); hold on
scatter([042 042 042 042 042 042 042 042],plastic_pirates_uncertainty,15,'filled','Markerfacecolor',[0/255,0/255,0/255],'HandleVisibility','off'); hold on


%% Inset in uncertainty graph.
close all
figure('defaultAxesFontSize',13); t = tiledlayout(1,2,'TileSpacing','compact');
bgAx = axes(t,'XTick',[],'YTick',[],'Box','off');
bgAx.Layout.TileSpan = [1 2];

ax1 = axes(t);
plot(ax1,x_values(2:end),accuracy_increase,'LineWidth',1.5,'Color',[.4 .4 .4])
ax1.Box = 'off';
xlim(ax1,[0 500]); grid on;
xticks([0:50:500])
ylabel('Accuracy increase (%)'); xlabel ('Randomly sampled surface area')

ax2 = axes(t);
ax2.Layout.Tile = 2;
plot(ax2,x_values(2:end),accuracy_increase,'LineWidth',1.5,'Color',[.4 .4 .4])
ax2.YAxis.Visible = 'off';
ax2.Box = 'off';
xlim(ax2,[500 2500]); grid on;
xticks([1000:500:2500])
linkaxes([ax1 ax2], 'y')

%% Plotting violinplots of item density per location (requires ViolinPlot app)
close all

files = dir('C:\Users\Paolo Tasseron\OneDrive - Wageningen University & Research\Paper projects\Riverbank detailed experiments paper\mat_files_montecarlo\2023_01_24_MonteCarlo_runs\');
for i = 3:10; load(files(i).name); end %loading .mat files of MC distributions

distribution = [Alphen',Arnhem',Doesburg',Nijmegen',Rhenen',Tiel',Vuren',Wanssum'];
title_array = {'Alphen','Arnhem','Doesburg','Nijmegen','Rhenen','Tiel','Vuren','Wanssum'};

f = figure; set(gcf,'Position',[50 50 1200 700]); i = 1;
color1 = [221/255 170/255 51/255];
color2 = [187/255 85/255 102/255];
color3 = [15/255 68/255 136/255];
color4 = [15/255 15/255 15/255];
correction = [10/255 10/255 10/255];

distribution_all = [];

for u = 0:4:28
    distribution_table = array2table(distribution(:,u+1:u+4),'VariableNames',{'PP','NOAA','CW','BAT'});
    distribution_all = [distribution_all;distribution_table];
    subplot(2,4,i); title(title_array(i)); grid on; xlim([0.5 4.5]);
    p = violinplot(distribution_table);
    if (i == 1 || i == 5)
        ylabel('Item density (items/m^2)')
    end
    for j = 1:length(p)
        p(:,j).ViolinAlpha = {1};
        p(:,j).ShowData = 0; 
        p(1,1).ViolinColor = {color1}; p(1,1).EdgeColor = [color1-correction];
        p(1,2).ViolinColor = {color2}; p(1,2).EdgeColor = [color2-correction];
        p(1,3).ViolinColor = {color3}; p(1,3).EdgeColor = [color3-correction];
        p(1,4).ViolinColor = {color4}; p(1,4).EdgeColor = [color4-correction];
        p(:,j).BoxColor = [1 1 1];
        p(:,j).MedianColor = [.8 .8 .8];
    end
    i = i+1;
end

%% Plotting violin plots of all locations combined
close all
figure; p = violinplot(distribution_all); grid on
p(1,1).ViolinColor = {color1}; p(1,1).EdgeColor = [color1-correction];
p(1,2).ViolinColor = {color2}; p(1,2).EdgeColor = [color2-correction];
p(1,3).ViolinColor = {color3}; p(1,3).EdgeColor = [color3-correction];
p(1,4).ViolinColor = {color4}; p(1,4).EdgeColor = [color4-correction];

for j = 1:4
    p(:,j).BoxColor = [1 1 1];
    p(:,j).MedianColor = [.8 .1 .1];
end

 ylabel('Item density (items/m^2)');

%% Calculating Global Moran I for the datasets
close all

matrix = data_river_oriented_wanssum; %input matrix for Moran's I calculation

% Number of regions
n = numel(matrix);

% Step 1: Define function to compute rook weights
rook_weights = zeros(n, n);
for i = 1:n
    for j = 1:n
        if i ~= j && (abs(i - j) == 1 || abs(i - j) == sqrt(n))
            rook_weights(i, j) = 1;
        end
    end
end

% Step 2: Compute spatial lag
spatial_lag = sum(rook_weights, 2);

% Step 3: Compute Moran's I
mean_x = mean(matrix(:));
numerator = 0;
denominator = 0;

for i = 1:n
    xi = matrix(i);
    xi_bar = mean_x;

    for j = 1:n
        xj = matrix(j);
        w_ij = rook_weights(i, j);
        numerator = numerator + w_ij * (xi - xi_bar) * (xj - xi_bar);
     end
    denominator = denominator + (xi - xi_bar)^2;
end

moran_i = n * numerator / (sum(spatial_lag) * denominator);

% Display results
disp(['Moran''s I value: ', num2str(moran_i)]);

%% Moran's I v.s. average normalized standard deviation (protocol sampling)
close all
x = [0.10569 0.023408 0.26794 0.073269 0.28673 -0.049663 0.23361 0.30127];
y = [0.73555 0.528975 0.416375 0.11535 0.7205 0.299875 0.523475 0.495175];

a = corrcoef(x,y)
[rho,pval] = corr(x',y','type','pearson')

scatter(x,y,'filled','k'); lsline; grid on

xlabel('Morans I'); ylabel('Normalized standard deviation (sampling protocols)');
xlim([-.2 .4]); ylim([0 1])
fitlm(x,y);  legend({'R-squared: 0.161'})

function normalized_function = normalize_function(func, x_values)
    % Calculate y values for the piecewise function
    y_values = func(x_values);
    
    % Normalize y values between 0 and 1
    normalized_function = (y_values - min(y_values)) / (max(y_values) - min(y_values));
end